'use client';

import PageHeader from "@/components/layout/Pages/PageHeader"
import { useEffect, useState, useRef } from "react";
import { useLocale, useTranslations } from 'next-intl';
import { motion, Variants, useScroll, useTransform } from "motion/react"
interface LocalizedText {
  ar: string;
  en: string;
}
interface JobOpportunity {
  id: number;
  publisher_date: string;
  title: string;
  description: string;
  tags: string[];
}

export default function Content() {
  const locale = useLocale();
  const [title, setTitle] = useState<object>({})
  const [description, setDescription] = useState<object>({})
  const [selectedJob, setSelectedJob] = useState<JobOpportunity|undefined>(undefined);
  const detailsRef = useRef<HTMLDivElement>(null);
  const t = useTranslations('Careers');

  const handleJobClick = (item:JobOpportunity) => {
    setSelectedJob(undefined);
    setSelectedJob(item);
    setTimeout(() => {
      detailsRef.current?.scrollIntoView({
        behavior: "smooth",
        block: "start"
      });
    }, 100);
  };

  useEffect(() => {
    setTitle({
      ar: "الوظائف",
      en: "Careers",
    })
    setDescription({
      ar: "انضم إلى فريق عملنا وساهم في بناء مشاريع نوعية تترك أثرًا حقيقيًا. نوفر بيئة مهنية محفّزة، \n وفرصًا للنمو والتطوير، ووظائف متنوعة تلائم الخبرات الهندسية والإدارية والفنية.",
      en: "Join our team and contribute to building high-quality projects that leave a real impact. \n We provide a stimulating professional environment, growth opportunities, and diverse roles for engineering, administrative, and technical expertise."
    })
  }, [])


  const items = [
    {
      "id": 1,
      "publisher_date": "12 نوفمبر 2025",
      "title": "مهندس موقع خبير",
      "description": "<div class='job-details'><h3>المهام الرئيسية</h3><p>نبحث عن مهندس مدني متمكن للانضمام إلى فريق إدارة المشاريع لدينا لضمان تنفيذ المشاريع بجودة عالية وفي الوقت المحدد. المرشح المثالي سيكون مسؤولاً عن متابعة كافة مراحل المشروع والتأكد من الالتزام بالمعايير الهندسية وإدارة الفريق الفني بكفاءة.</p><h3>المتطلبات</h3><ul><li>بكالوريوس هندسة مدنية أو ما يعادلها.</li><li>خبرة 3-5 سنوات في مشاريع البناء والتشييد.</li><li>معرفة جيدة ببرامج إدارة المشاريع مثل MS Project أو Primavera.</li><li>مهارات تواصل ممتازة وقدرة على العمل ضمن فريق.</li><li>قدرة على إدارة الوقت وحل المشكلات تحت ضغط العمل.</li></ul><h3>المميزات</h3><ul><li>راتب تنافسي مع حوافز الأداء.</li><li>فرص تدريب وتطوير مهني مستمر.</li><li>بيئة عمل محترفة وداعمة.</li><li>مشاريع كبيرة ومتنوعة تمنح خبرة عملية متميزة.</li></ul></div>",
      "tags": ["دوام كامل", "القاهرة", "3 سنوات"]
    },
    {
      "id": 2,
      "publisher_date": "20 ديسمبر 2024",
      "title": "مدير مشروع",
      "description": "<div class='job-details'><h3>الوصف الوظيفي</h3><p>تخطيط وتنفيذ المشاريع البرمجية وضمان تسليمها في المواعيد المحددة مع إدارة الموارد المتاحة.</p><h3>المتطلبات</h3><ul><li>خبرة في إدارة المشاريع التقنية.</li><li>إجادة منهجيات Agile/Scrum.</li></ul></div>",
      "tags": ["دوام جزئي", "الإسكندرية", "5 سنوات"]
    }
  ]


  return (
    <>
      <PageHeader title={(title as any)[locale || 'ar']} description={(description as any)[locale || 'ar']} />
      <div className='h-77.57 w-full flex flex-col justify-start items-center gap-0'>
        <div id="jobDescription" ref={detailsRef} className="container flex flex-col justify-center items-center gap-5 py-10 px-4 md-px-0">
          <div className="flex w-full rounded-lg bg-gray-100 h-16 flex-row justify-start items-center px-2">
            <svg className="h-6 w-6" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
              <g clipPath="url(#clip0_14170_886)">
                <path d="M23.707 22.2928L17.738 16.3238C19.3647 14.3344 20.1644 11.7959 19.9719 9.23334C19.7793 6.67081 18.6092 4.28031 16.7036 2.5563C14.798 0.832293 12.3026 -0.0933258 9.73367 -0.029094C7.16472 0.0351379 4.71873 1.08431 2.90164 2.9014C1.08455 4.71849 0.035382 7.16447 -0.0288498 9.73342C-0.0930816 12.3024 0.832537 14.7977 2.55655 16.7034C4.28056 18.609 6.67106 19.7791 9.23359 19.9716C11.7961 20.1642 14.3346 19.3644 16.324 17.7378L22.293 23.7068C22.4816 23.8889 22.7342 23.9897 22.9964 23.9875C23.2586 23.9852 23.5094 23.88 23.6948 23.6946C23.8803 23.5092 23.9854 23.2584 23.9877 22.9962C23.99 22.734 23.8892 22.4814 23.707 22.2928ZM10 17.9998C8.41778 17.9998 6.87106 17.5306 5.55546 16.6515C4.23987 15.7725 3.21449 14.5231 2.60899 13.0613C2.00349 11.5994 1.84506 9.99091 2.15374 8.43906C2.46243 6.88721 3.22435 5.46175 4.34317 4.34293C5.46199 3.22411 6.88746 2.46218 8.4393 2.1535C9.99115 1.84482 11.5997 2.00324 13.0615 2.60875C14.5233 3.21425 15.7727 4.23963 16.6518 5.55522C17.5308 6.87081 18 8.41753 18 9.99978C17.9976 12.1208 17.154 14.1542 15.6543 15.654C14.1545 17.1538 12.121 17.9974 10 17.9998Z" fill="#FF6400" />
              </g>
              <defs>
                <clipPath id="clip0_14170_886">
                  <rect width="24" height="24" fill="white" />
                </clipPath>
              </defs>
            </svg>

            <input placeholder={locale == "ar" ? "ابحث عن وظيفة" : "Search for a Job"} className="w-full placeholder:text-gray-400 flex h-full p-2 outline-0" />

          </div>
          <div className="flex w-full rounded-lg flex-row justify-between gap-2 px-2">
            <div className="flex w-fit flex-row gap-2 justify-start flex-wrap ">
              <div className="relative flex w-full md:w-fit justify-between flex-row md:justify-start bg-gray-100 p-2 gap-2 rounded-lg cursor-pointer">
                <div className="text-gray-600 font-main font-medium">{locale == "ar" ? "التخصص" : "Specialization"}</div>
                <svg className="w-6 h-6" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M18.7101 8.20986C18.6171 8.11613 18.5065 8.04174 18.3846 7.99097C18.2628 7.9402 18.1321 7.91406 18.0001 7.91406C17.868 7.91406 17.7373 7.9402 17.6155 7.99097C17.4936 8.04174 17.383 8.11613 17.2901 8.20986L12.7101 12.7899C12.6171 12.8836 12.5065 12.958 12.3846 13.0088C12.2628 13.0595 12.1321 13.0857 12.0001 13.0857C11.868 13.0857 11.7373 13.0595 11.6155 13.0088C11.4936 12.958 11.383 12.8836 11.2901 12.7899L6.71006 8.20986C6.6171 8.11613 6.5065 8.04174 6.38464 7.99097C6.26278 7.9402 6.13207 7.91406 6.00006 7.91406C5.86805 7.91406 5.73734 7.9402 5.61548 7.99097C5.49362 8.04174 5.38302 8.11613 5.29006 8.20986C5.10381 8.39722 4.99927 8.65067 4.99927 8.91486C4.99927 9.17905 5.10381 9.4325 5.29006 9.61986L9.88006 14.2099C10.4426 14.7717 11.2051 15.0872 12.0001 15.0872C12.7951 15.0872 13.5576 14.7717 14.1201 14.2099L18.7101 9.61986C18.8963 9.4325 19.0009 9.17905 19.0009 8.91486C19.0009 8.65067 18.8963 8.39722 18.7101 8.20986Z" fill="#64687D" />
                </svg>
              </div>
              <div className="relative flex w-full md:w-fit justify-between flex-row md:justify-start bg-gray-100 p-2 gap-2 rounded-lg cursor-pointer">
                <div className="text-gray-600 font-main font-medium">{locale == "ar" ? "دوام كامل" : "Full Time"}</div>
                <svg className="w-6 h-6" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M18.7101 8.20986C18.6171 8.11613 18.5065 8.04174 18.3846 7.99097C18.2628 7.9402 18.1321 7.91406 18.0001 7.91406C17.868 7.91406 17.7373 7.9402 17.6155 7.99097C17.4936 8.04174 17.383 8.11613 17.2901 8.20986L12.7101 12.7899C12.6171 12.8836 12.5065 12.958 12.3846 13.0088C12.2628 13.0595 12.1321 13.0857 12.0001 13.0857C11.868 13.0857 11.7373 13.0595 11.6155 13.0088C11.4936 12.958 11.383 12.8836 11.2901 12.7899L6.71006 8.20986C6.6171 8.11613 6.5065 8.04174 6.38464 7.99097C6.26278 7.9402 6.13207 7.91406 6.00006 7.91406C5.86805 7.91406 5.73734 7.9402 5.61548 7.99097C5.49362 8.04174 5.38302 8.11613 5.29006 8.20986C5.10381 8.39722 4.99927 8.65067 4.99927 8.91486C4.99927 9.17905 5.10381 9.4325 5.29006 9.61986L9.88006 14.2099C10.4426 14.7717 11.2051 15.0872 12.0001 15.0872C12.7951 15.0872 13.5576 14.7717 14.1201 14.2099L18.7101 9.61986C18.8963 9.4325 19.0009 9.17905 19.0009 8.91486C19.0009 8.65067 18.8963 8.39722 18.7101 8.20986Z" fill="#64687D" />
                </svg>
              </div>
              <div className="relative flex w-full md:w-fit justify-between flex-row md:justify-start bg-gray-100 p-2 gap-2 rounded-lg cursor-pointer">
                <div className="text-gray-600 font-main font-medium">{locale == "ar" ? "الموقع" : "Location"}</div>
                <svg className="w-6 h-6" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M18.7101 8.20986C18.6171 8.11613 18.5065 8.04174 18.3846 7.99097C18.2628 7.9402 18.1321 7.91406 18.0001 7.91406C17.868 7.91406 17.7373 7.9402 17.6155 7.99097C17.4936 8.04174 17.383 8.11613 17.2901 8.20986L12.7101 12.7899C12.6171 12.8836 12.5065 12.958 12.3846 13.0088C12.2628 13.0595 12.1321 13.0857 12.0001 13.0857C11.868 13.0857 11.7373 13.0595 11.6155 13.0088C11.4936 12.958 11.383 12.8836 11.2901 12.7899L6.71006 8.20986C6.6171 8.11613 6.5065 8.04174 6.38464 7.99097C6.26278 7.9402 6.13207 7.91406 6.00006 7.91406C5.86805 7.91406 5.73734 7.9402 5.61548 7.99097C5.49362 8.04174 5.38302 8.11613 5.29006 8.20986C5.10381 8.39722 4.99927 8.65067 4.99927 8.91486C4.99927 9.17905 5.10381 9.4325 5.29006 9.61986L9.88006 14.2099C10.4426 14.7717 11.2051 15.0872 12.0001 15.0872C12.7951 15.0872 13.5576 14.7717 14.1201 14.2099L18.7101 9.61986C18.8963 9.4325 19.0009 9.17905 19.0009 8.91486C19.0009 8.65067 18.8963 8.39722 18.7101 8.20986Z" fill="#64687D" />
                </svg>
              </div>
              <div className="relative flex w-full md:w-fit justify-between flex-row md:justify-start bg-gray-100 p-2 gap-2 rounded-lg cursor-pointer">
                <div className="text-gray-600 font-main font-medium">{locale == "ar" ? "أكثر من 5 سنوات" : "More than 5 years"}</div>
                <svg className="w-6 h-6" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M18.7101 8.20986C18.6171 8.11613 18.5065 8.04174 18.3846 7.99097C18.2628 7.9402 18.1321 7.91406 18.0001 7.91406C17.868 7.91406 17.7373 7.9402 17.6155 7.99097C17.4936 8.04174 17.383 8.11613 17.2901 8.20986L12.7101 12.7899C12.6171 12.8836 12.5065 12.958 12.3846 13.0088C12.2628 13.0595 12.1321 13.0857 12.0001 13.0857C11.868 13.0857 11.7373 13.0595 11.6155 13.0088C11.4936 12.958 11.383 12.8836 11.2901 12.7899L6.71006 8.20986C6.6171 8.11613 6.5065 8.04174 6.38464 7.99097C6.26278 7.9402 6.13207 7.91406 6.00006 7.91406C5.86805 7.91406 5.73734 7.9402 5.61548 7.99097C5.49362 8.04174 5.38302 8.11613 5.29006 8.20986C5.10381 8.39722 4.99927 8.65067 4.99927 8.91486C4.99927 9.17905 5.10381 9.4325 5.29006 9.61986L9.88006 14.2099C10.4426 14.7717 11.2051 15.0872 12.0001 15.0872C12.7951 15.0872 13.5576 14.7717 14.1201 14.2099L18.7101 9.61986C18.8963 9.4325 19.0009 9.17905 19.0009 8.91486C19.0009 8.65067 18.8963 8.39722 18.7101 8.20986Z" fill="#64687D" />
                </svg>
              </div>
            </div>
            <div className="flex w-full items-center md:w-fit flex-row gap-2 justify-end">
              <div className="relative flex w-full md:w-fit justify-between flex-row md:justify-start bg-gray-100 p-2 gap-2 rounded-lg cursor-pointer">
                <div className="text-gray-600 font-main font-medium">{locale == "ar" ? "ترتيب حسب" : "Sort by"}</div>
                <svg className="w-6 h-6" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <g clipPath="url(#clip0_14170_881)">
                    <path d="M18 5.92C18 3.758 16.242 2 14.08 2H3.92C1.758 2 0 3.758 0 5.92C0 6.855 0.335 7.761 0.944 8.471L6 14.37V18C6 18.315 6.148 18.611 6.4 18.8L10.4 21.8C10.577 21.932 10.788 22 11 22C11.152 22 11.306 21.965 11.447 21.895C11.786 21.726 12 21.379 12 21V14.37L17.056 8.471C17.665 7.761 18 6.855 18 5.92ZM15.538 7.17L10.241 13.35C10.086 13.531 10 13.762 10 14.001V19.001L8 17.501V14.001C8 13.762 7.915 13.531 7.759 13.35L2.462 7.169C2.164 6.821 2 6.377 2 5.919C2 4.86 2.861 3.999 3.92 3.999H14.08C15.139 3.999 16 4.86 16 5.919C16 6.377 15.836 6.822 15.538 7.17ZM24 20.001C24 20.553 23.552 21.001 23 21.001H15C14.448 21.001 14 20.553 14 20.001C14 19.449 14.448 19.001 15 19.001H23C23.552 19.001 24 19.449 24 20.001ZM24 16.001C24 16.553 23.552 17.001 23 17.001H15C14.448 17.001 14 16.553 14 16.001C14 15.449 14.448 15.001 15 15.001H23C23.552 15.001 24 15.449 24 16.001ZM18 11.001H23C23.552 11.001 24 11.449 24 12.001C24 12.553 23.552 13.001 23 13.001H18C17.448 13.001 17 12.553 17 12.001C17 11.449 17.448 11.001 18 11.001Z" fill="#64687D" />
                  </g>
                  <defs>
                    <clipPath id="clip0_14170_881">
                      <rect width="24" height="24" fill="white" />
                    </clipPath>
                  </defs>
                </svg>

              </div>
            </div>
          </div>
          <div className="flex w-full rounded-lg flex-row justify-start divide-x px-2">
            <div className="px-2 text-gray-400 font-almarai font-light">نتائج البحث</div>
            <div className="px-2 text-main-orange font-almarai font-light">56 وظيفة</div>
          </div>
          <div className="flex w-full flex-col md:flex-row justify-start gap-10">
            <div className="flex  order-2 md:order-1 flex-3 flex-col w-full gap-5">
              {items.map((item) => (
                <div
                  key={item.id}
                  onClick={() => {
                    handleJobClick(item);
                  }}
                  className={`w-full flex flex-row h-fit rounded-xl items-center p-4 cursor-pointer transition-all border-2 ease-in translate-0.5 ${selectedJob?.id === item.id ? 'bg-gray-100 border-main-orange' : 'bg-gray-50 border-transparent hover:bg-gray-100'
                    }`}
                >
                  <div className="flex w-full flex-col gap-3">
                    <div className="font-almarai font-light text-[14px] text-gray-600">{item.publisher_date}</div>
                    <div className="font-main font-bold text-lg text-main-blue">{item.title}</div>
                    <div className="w-full flex flex-row gap-2 flex-wrap">
                      {item.tags.map((txt, i) => (
                        <div key={i} className="font-main text-[14px] bg-white p-2 rounded-lg text-main-orange">
                          {txt}
                        </div>
                      ))}
                    </div>
                  </div>
                  <svg className={`size-6 transition-transform ${locale === 'ar' ? '' : 'rotate-180'}`} viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15.79 5.29019C15.8837 5.38315 15.79 18.7102L9.79002 14.1202C9.22822 13.5577 8.91266 12.0002 9.79002 9.88018L14.38 5.29019Z" fill="#64687D" />
                  </svg>
                </div>
              ))}
            </div>

            <div className="flex order-1 md:order-2 flex-4 h-fit w-full flex-col gap-3 rounded-xl">
              {selectedJob ? (
                <motion.div
                  key={selectedJob.id}
                  initial={{ opacity: 0, y: 20 }}
                  animate={{ opacity: 1, y: 0 }}
                  transition={{ duration: 0.5, ease: "easeOut" }}
                  className="flex flex-col gap-4 bg-gray-100 rounded-xl">
                  <div className="font-almarai font-light text-[14px] text-gray-600 px-5 pt-5">{selectedJob.publisher_date}</div>
                  <div className="font-main font-bold text-lg text-main-blue px-5">{selectedJob.title}</div>
                  <div className="w-full flex flex-row gap-2 flex-wrap px-5">
                    {selectedJob.tags.map((txt, i) => (
                      <div key={i} className="font-main text-[14px] bg-white p-2 rounded-lg text-main-orange">
                        {txt}
                      </div>
                    ))}
                  </div>
                  <div
                    className="font-almarai font-light text-[14px]  px-5 text-gray-600"
                    dangerouslySetInnerHTML={{ __html: selectedJob.description }}
                  />
                  <div className="w-full items-center bg-gray-200 p-4 rounded-b-xl py-5 flex flex-row  flex-wrap gap-5 justify-between">
                    <div className="text-base font-almarai text-main-blue">{t('AreYouFitForThisRole')}</div>
                    <div onClick={() => { alert("soon") }} className="flex cursor-pointer w-fit p-2 items-center flex-row gap-2 bg-main-orange rounded-xl">
                      <div className="text-white font-semibold font-main text-base">{t("JoinOurTeam")}</div>
                      <svg className="size-9" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect width="36" height="36" rx="10" fill="white" />
                        <path d="M24 16.9998H14L17.29 13.7098C17.3837 13.6169 17.4581 13.5063 17.5089 13.3844C17.5597 13.2625 17.5858 13.1318 17.5858 12.9998C17.5858 12.8678 17.5597 12.7371 17.5089 12.6152C17.4581 12.4934 17.3837 12.3828 17.29 12.2898C17.1026 12.1036 16.8492 11.999 16.585 11.999C16.3208 11.999 16.0674 12.1036 15.88 12.2898L11.59 16.5898C11.2144 16.9632 11.0022 17.4702 11 17.9998C11.0049 18.5259 11.2168 19.0289 11.59 19.3998L15.88 23.6998C15.9732 23.7924 16.0838 23.8657 16.2054 23.9156C16.3269 23.9654 16.4571 23.9908 16.5885 23.9904C16.7199 23.9899 16.8499 23.9636 16.9712 23.9129C17.0924 23.8621 17.2024 23.7881 17.295 23.6948C17.3876 23.6016 17.4609 23.491 17.5107 23.3694C17.5606 23.2479 17.586 23.1177 17.5856 22.9863C17.5851 22.8549 17.5588 22.7249 17.508 22.6037C17.4573 22.4824 17.3832 22.3724 17.29 22.2798L14 18.9998H24C24.2652 18.9998 24.5196 18.8945 24.7071 18.7069C24.8946 18.5194 25 18.265 25 17.9998C25 17.7346 24.8946 17.4802 24.7071 17.2927C24.5196 17.1052 24.2652 16.9998 24 16.9998Z" fill="#FF6400" />
                      </svg>
                    </div>
                  </div>
                </motion.div>
              ) : (
                <motion.div
                  initial={{ opacity: 0 }}
                  animate={{ opacity: 1 }}
                  className="h-full flex items-center justify-center text-gray-400 font-almarai  p-5 bg-gray-100 rounded-xl">
                  {locale === 'ar' ? 'برجاء اختيار وظيفة لعرض التفاصيل' : 'Please select a job to view details'}
                </motion.div>
              )}
            </div>
          </div>
        </div>
      </div>
    </>
  );
}